package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 03/04/2017.
 * Search on database for results to fill in TB 11 Form Block 3 table tested
 */
public class TBForm11Block3TestedQuery implements TbFormQuery {

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        List<Object[]> result = new ArrayList<Object[]>();
        String queryStr;

        // Total Registered - 0 is ordinal for TOTAL_REGISTERED in TBForm11.SuperColumn
        queryStr = " select 0, c.patientType, c.infectionSite, c.caseDefinition, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48)"
                + " and c.state is not null and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null"
                + " and exists(from ExamHIV e where e.tbcase.id = c.id)"
                + " group by c.patientType, c.infectionSite, c.caseDefinition, p.gender ";
        result.addAll(createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Successfully Treated until 14 years old - 1 is ordinal for SUCCESSFULLY_TREATED_UNTIL_14 in TBForm11.SuperColumn
        queryStr = " select 1, c.patientType, c.infectionSite, c.caseDefinition, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48)"
                + " and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null"
                + " and c.age <= 14 and c.state in (3,4) "
                + " and exists(from ExamHIV e where e.tbcase.id = c.id)"
                + " group by c.patientType, c.infectionSite, c.caseDefinition, p.gender ";
        result.addAll(createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Successfully Treated after 14 years old - 2 is ordinal for SUCCESSFULLY_TREATED_AFTER_14 in TBForm11.SuperColumn
        queryStr = " select 2, c.patientType, c.infectionSite, c.caseDefinition, p.gender, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48)"
                + " and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null"
                + " and c.age > 14 and c.state in (3,4) "
                + " and exists(from ExamHIV e where e.tbcase.id = c.id)"
                + " group by c.patientType, c.infectionSite, c.caseDefinition, p.gender ";
        result.addAll(createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Other outcomes - 3 is ordinal for OTHER_OUTCOMES in TBForm11.SuperColumn
        queryStr = " select 3, c.patientType, c.infectionSite, c.caseDefinition, p.gender, c.state, count (*)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48) and c.state not in (3,4)"
                + " and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null and c.state is not null "
                + " and exists(from ExamHIV e where e.tbcase.id = c.id)"
                + " group by c.patientType, c.infectionSite, c.caseDefinition, p.gender, c.state ";
        result.addAll(createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        return result;
    }

    /**
     * Creates Query instance for query string passed as param
     * @param queryStr
     * @param tbunit
     * @param adminUnit
     * @param workspace
     * @param quarter
     * @param em
     * @return
     */
    private Query createQuery(String queryStr, Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter quarter, EntityManager em) {
        Query query;

        if (tbunit != null) {
            // add tbunit restriction
            queryStr = queryStr.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            query = em.createQuery(queryStr);
            query.setParameter("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction
            queryStr = queryStr.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            query = em.createQuery(queryStr);
            query.setParameter("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction
            queryStr = queryStr.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            query = em.createQuery(queryStr);
            query.setParameter("wsId", workspace.getId());
        } else {
            throw new RuntimeException("TBForm11Block1Query: Tbunit, adminunit or workspace must be set.");
        }

        query.setParameter("iniDate", quarter.getIniDate());
        query.setParameter("endDate", quarter.getEndDate());

        return query;
    }
}
